/*---------------------------------------------------------------------------*\

    FILE....: ringmon.CPP
    TYPE....: C++ Console program
    AUTHOR..: Ben Kramer
    DATE....: 31/01/03

    Monitors and counts ring events, and reports others as erroneous

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "kbhit.h"

#include "../src/vpbapi.h"

#define MAX_CH 12

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h[MAX_CH],i,ret,arg,ch,ringc[MAX_CH];

	VPB_EVENT	e;
	char		s[VPB_MAX_STR];

	h[0] = vpb_open(1,1);
	ch = vpb_get_ports_per_card();
	vpb_close(h[0]);

	for(i=0; i<ch; i++) {
		h[i] = vpb_open(1,i+1);
		vpb_sethook_sync(h[i],VPB_OFFHOOK);
		ringc[i]=0;
	}

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			if (e.type == VPB_RING) {
				ringc[e.handle]++;
				printf("Ring on ch %d, total: %d \n",e.handle,ringc[e.handle]);
			}
			else if (e.type == VPB_DROP) {
				printf("ERROR: %s",s);
			}
		}
		vpb_sleep(100);

	} while(!kbhit());

	for(i=0; i<ch; i++) {
		vpb_sethook_sync(h[i],VPB_ONHOOK);
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}








